/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.github;

import com.aptana.core.util.StringUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubManager;
import com.aptana.git.core.github.IGithubPullRequest;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.internal.core.github.GithubAPI;
import com.aptana.git.internal.core.github.GithubPullRequest;
import com.aptana.git.internal.core.github.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GithubRepository
implements IGithubRepository {
    private static final String PARENT = "parent";
    private static final String SOURCE = "source";
    private static final String LOGIN = "login";
    private static final String OWNER = "owner";
    private static final String DEFAULT_BRANCH = "default_branch";
    private static final String FORK = "fork";
    private static final String PRIVATE = "private";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String ATTR_SSH_URL = "ssh_url";
    private JSONObject json;

    public GithubRepository(JSONObject repo) {
        this.json = repo;
    }

    @Override
    public long getID() {
        if (!this.json.containsKey((Object)ID)) {
            return -1L;
        }
        return (Long)this.json.get((Object)ID);
    }

    @Override
    public String getName() {
        return (String)this.json.get((Object)NAME);
    }

    @Override
    public String getFullName() {
        return String.valueOf(this.getOwner()) + '/' + this.getName();
    }

    @Override
    public boolean isPrivate() {
        if (!this.json.containsKey((Object)PRIVATE)) {
            return false;
        }
        return (Boolean)this.json.get((Object)PRIVATE);
    }

    @Override
    public boolean isFork() {
        if (!this.json.containsKey((Object)FORK)) {
            return false;
        }
        return (Boolean)this.json.get((Object)FORK);
    }

    @Override
    public String getSSHURL() {
        return (String)this.json.get((Object)ATTR_SSH_URL);
    }

    @Override
    public String getDefaultBranch() {
        return (String)this.json.get((Object)DEFAULT_BRANCH);
    }

    @Override
    public String getOwner() {
        JSONObject owner = (JSONObject)this.json.get((Object)OWNER);
        return (String)owner.get((Object)LOGIN);
    }

    @Override
    public IGithubRepository getParent() throws CoreException {
        if (!this.isFork()) {
            return null;
        }
        if (!this.json.containsKey((Object)PARENT)) {
            this.getDetailedJSON();
        }
        return new GithubRepository((JSONObject)this.json.get((Object)PARENT));
    }

    @Override
    public IGithubRepository getSource() throws CoreException {
        if (!this.isFork()) {
            return this;
        }
        if (!this.json.containsKey((Object)SOURCE)) {
            this.getDetailedJSON();
        }
        return new GithubRepository((JSONObject)this.json.get((Object)SOURCE));
    }

    protected void getDetailedJSON() throws CoreException {
        this.json = (JSONObject)this.getAPI().get(this.getAPIURL());
    }

    protected String getAPIURL() {
        return "repos/" + this.getOwner() + "/" + this.getName();
    }

    protected GithubAPI getAPI() {
        return new GithubAPI(this.getGithubManager().getUser());
    }

    @Override
    public IGithubPullRequest createPullRequest(String title, String body, GitRepository head, IGithubRepository baseRepo, String baseBranch, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.GithubRepository_GeneratingPRTaskName, (int)100);
        String branch = head.currentBranch();
        sub.subTask(Messages.GithubRepository_PushingBranchSubtaskName);
        IStatus pushStatus = head.push("origin", branch);
        sub.worked(50);
        if (!pushStatus.isOK()) {
            throw new CoreException(pushStatus);
        }
        sub.subTask(Messages.GithubRepository_SubmittingPRSubtaskName);
        JSONObject prObject = new JSONObject();
        prObject.put((Object)"title", (Object)title);
        prObject.put((Object)"body", (Object)body);
        prObject.put((Object)"head", (Object)(String.valueOf(this.getOwner()) + ':' + branch));
        prObject.put((Object)"base", (Object)baseBranch);
        JSONObject result = (JSONObject)this.getAPI().post(String.valueOf(((GithubRepository)baseRepo).getAPIURL()) + "/pulls", prObject.toJSONString());
        return new GithubPullRequest(result);
    }

    protected IGithubManager getGithubManager() {
        return GitPlugin.getDefault().getGithubManager();
    }

    public String toString() {
        return this.json.toJSONString();
    }

    @Override
    public List<IGithubPullRequest> getOpenPullRequests() throws CoreException {
        JSONArray result = (JSONArray)this.getAPI().get(String.valueOf(this.getAPIURL()) + "/pulls");
        ArrayList<IGithubPullRequest> prs = new ArrayList<IGithubPullRequest>(result.size());
        for (Object blah : result) {
            JSONObject pr = (JSONObject)blah;
            prs.add(new GithubPullRequest(pr));
        }
        return prs;
    }

    @Override
    public Set<String> getBranches() {
        IStatus status = this.getGitExecutable().runInBackground(null, "ls-remote", "--heads", this.getSSHURL());
        if (!status.isOK()) {
            return Collections.emptySet();
        }
        String[] lines = StringUtil.LINE_SPLITTER.split(status.getMessage());
        HashSet<String> branches = new HashSet<String>(lines.length);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String pastSha = line.substring(40).trim();
            if (pastSha.startsWith("refs/heads/")) {
                branches.add(pastSha.substring("refs/heads/".length()));
            }
            ++n2;
        }
        return branches;
    }

    protected GitExecutable getGitExecutable() {
        return GitExecutable.instance();
    }

    @Override
    public List<IGithubRepository> getForks() throws CoreException {
        JSONArray result = (JSONArray)this.getAPI().get(String.valueOf(this.getAPIURL()) + "/forks");
        ArrayList<IGithubRepository> repos = new ArrayList<IGithubRepository>(result.size());
        for (Object blah : result) {
            JSONObject pr = (JSONObject)blah;
            repos.add(new GithubRepository(pr));
        }
        return repos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.getID() ^ this.getID() >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GithubRepository)) {
            return false;
        }
        GithubRepository other = (GithubRepository)obj;
        return this.getID() == other.getID();
    }
}

